
set more off 	
pause off
set logtype text
set mem 500M

set scheme s1color , permanently

*************** DESCRIPTION ***************************************************
* Generates results for section V.C: Globalization 
*
*	Inputs:  3.Final_data/main_dataset_ind_MNE
*	Outputs: Figures and Tables included in paper, numbered as in the final 
*			 paper and stored in corresponding folders
* 
*******************************************************************************   

use "3.Final_data/main_dataset_ind_MNE", clear
drop if year >= 2016

merge 1:1 ind_short year using 2.intermediate/BEA_mne
drop if _merge == 2 & ind_short ~= "All"
drop _merge

encode(ind_short),g(indgr)
xtset indgr year


***


/*-------------------------*/
/*	 EXPLORATORY PLOTS     */
/*-------------------------*/

g a1a_ni_ma3 = (f.a1a_ni+a1a_ni+l.a1a_ni)/3
g a1p_ni_ma3 = (f.a1p_ni+a1p_ni+l.a1p_ni)/3

foreach X in at capx sale ni ni_ma3 va comp {
	g pct_`X' = a1a_`X' / (a1p_`X'+a1a_`X')
	g temp = pct_`X' if year == 1995
	egen temp2 = max(temp), by(indgr)
	g npct_`X'= pct_`X'/temp2
	drop temp*
}

label variable pct_at "Assets"
label variable npct_at "Assets"
label variable pct_capx "CAPX"
label variable npct_capx "CAPX"
label variable pct_sale "Sales"
label variable npct_sale "Sales"
label variable pct_ni_m "Net Income"
label variable npct_ni_m "Net Income"
label variable pct_va "VA"
label variable npct_va "VA"
label variable pct_comp "Labor Comp"
label variable npct_comp "Labor Comp"

scatter pct_at pct_capx pct_sale pct_ni_ma3 pct_va pct_comp  year if ind_s == "All", c(l l l l l l l) ms(i T Th O Oh) ti("% Foreign") 
graph export ../Figures/13a_MNE_pct.eps, as(eps)  replace
scatter npct_at npct_capx npct_sale npct_ni_ma3 npct_va npct_comp    year if ind_s == "All", c(l l l l l l l) ms(i T Th O Oh) ti("% Foreign (1995=1)")
graph export ../Figures/13b_MNE_normpct.eps, as(eps)  replace

window manage close graph 


***


/*-------------------------*/
/*	 REGRESSION ANALYSES   */
/*-------------------------*/

g a1mne_ik_exip = (a_ip_all_bea-a_ip_ip_bea + a1a_capx/1000)/(l.a_kp_all_bea-l.a_kp_ip_bea) 
g a1mne_ik_all = (a1_ip_all_bea + a1a_capx/1000)/l.a1_kp_all_bea 

* Generate de-meaned dependent variable for measurement-error corrected regressions
foreach X in a1_nik_all a1_nik_exip a1_nik_ip a1mne_ik_exip a1mne_ik_all {
	egen temp = mean(`X') if year >= 2000 & year <= 2014, by(indgr)
	g dm_`X' = `X' - temp
	g fdm_`X'  = f.dm_`X' 
	drop dm_`X' temp	
}


g a1med_logq_tot = log(a1med_q_tot)
* Generate de-meaned independent variables for measurement-error corrected regressions
foreach X in a1_q a1m_q a1med_q a1m_logq a1med_logq a1med_q_tot a1med_logq_tot a1med_owntotQIX a1m_owntotQIX mherf ///
			herf_s herf_adj  a1m_logage a1m_logat a1m_intanexgw a1m_pifoadj_sh  pct_ni_ma3 pct_capx pct_sale{
	egen temp = mean(`X') if year >= 1999 & year <= 2013, by(indgr)
	g dm_`X' = `X' - temp
	drop temp
}

xi i.year 


***

* XTEWREG
drop if ind_short == "All"

xtewreg fdm_a1_nik_all  dm_a1med_logq  dm_mherf dm_a1m_owntotQIX dm_pct_ni_ma3 dm_a1m_logage  _Iyear_2000-_Iyear_2013 if year>=1999 & year <= 2013, maxdeg(3) mis(1)
outreg2 using ../Tables/12_foreign_test.txt, append symbol(**, *, +) tstat nonote nocons br dec(4) e(rho)  drop(*logat *logage *year*) ctitle(>1999) sortvar(*logq* *QIX* *mherf* *herf*) addtext(Age Controls, YES, Year FE, YES, Industry de-meaned, YES)

xtewreg fdm_a1_nik_all  dm_a1med_logq  dm_mherf dm_a1m_owntotQIX dm_pct_capx dm_a1m_logage  _Iyear_2000-_Iyear_2013 if year>=1999 & year <= 2013, maxdeg(3) mis(1)
outreg2 using ../Tables/12_foreign_test.txt, append symbol(**, *, +) tstat nonote nocons br dec(4) e(rho)  drop(*logat *logage *year*) ctitle(>1999) sortvar(*logq* *QIX* *mherf* *herf*) addtext(Age Controls, YES, Year FE, YES, Industry de-meaned, YES)


